<?php

namespace App\Test\Controller;

use App\Entity\BioAuth;
use App\Repository\BioAuthRepository;
use Symfony\Bundle\FrameworkBundle\KernelBrowser;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

class BioAuthControllerTest extends WebTestCase
{
    private KernelBrowser $client;
    private BioAuthRepository $repository;
    private string $path = '/bio/auth/';

    protected function setUp(): void
    {
        $this->client = static::createClient();
        $this->repository = (static::getContainer()->get('doctrine'))->getRepository(BioAuth::class);

        foreach ($this->repository->findAll() as $object) {
            $this->repository->remove($object, true);
        }
    }

    public function testIndex(): void
    {
        $crawler = $this->client->request('GET', $this->path);

        self::assertResponseStatusCodeSame(200);
        self::assertPageTitleContains('BioAuth index');

        // Use the $crawler to perform additional assertions e.g.
        // self::assertSame('Some text on the page', $crawler->filter('.p')->first());
    }

    public function testNew(): void
    {
        $originalNumObjectsInRepository = count($this->repository->findAll());

        $this->markTestIncomplete();
        $this->client->request('GET', sprintf('%snew', $this->path));

        self::assertResponseStatusCodeSame(200);

        $this->client->submitForm('Save', [
            'bio_auth[identification]' => 'Testing',
            'bio_auth[dateCreated]' => 'Testing',
            'bio_auth[status]' => 'Testing',
            'bio_auth[application]' => 'Testing',
            'bio_auth[person]' => 'Testing',
        ]);

        self::assertResponseRedirects('/bio/auth/');

        self::assertSame($originalNumObjectsInRepository + 1, count($this->repository->findAll()));
    }

    public function testShow(): void
    {
        $this->markTestIncomplete();
        $fixture = new BioAuth();
        $fixture->setIdentification('My Title');
        $fixture->setDateCreated('My Title');
        $fixture->setStatus('My Title');
        $fixture->setApplication('My Title');
        $fixture->setPerson('My Title');

        $this->repository->add($fixture, true);

        $this->client->request('GET', sprintf('%s%s', $this->path, $fixture->getId()));

        self::assertResponseStatusCodeSame(200);
        self::assertPageTitleContains('BioAuth');

        // Use assertions to check that the properties are properly displayed.
    }

    public function testEdit(): void
    {
        $this->markTestIncomplete();
        $fixture = new BioAuth();
        $fixture->setIdentification('My Title');
        $fixture->setDateCreated('My Title');
        $fixture->setStatus('My Title');
        $fixture->setApplication('My Title');
        $fixture->setPerson('My Title');

        $this->repository->add($fixture, true);

        $this->client->request('GET', sprintf('%s%s/edit', $this->path, $fixture->getId()));

        $this->client->submitForm('Update', [
            'bio_auth[identification]' => 'Something New',
            'bio_auth[dateCreated]' => 'Something New',
            'bio_auth[status]' => 'Something New',
            'bio_auth[application]' => 'Something New',
            'bio_auth[person]' => 'Something New',
        ]);

        self::assertResponseRedirects('/bio/auth/');

        $fixture = $this->repository->findAll();

        self::assertSame('Something New', $fixture[0]->getIdentification());
        self::assertSame('Something New', $fixture[0]->getDateCreated());
        self::assertSame('Something New', $fixture[0]->getStatus());
        self::assertSame('Something New', $fixture[0]->getApplication());
        self::assertSame('Something New', $fixture[0]->getPerson());
    }

    public function testRemove(): void
    {
        $this->markTestIncomplete();

        $originalNumObjectsInRepository = count($this->repository->findAll());

        $fixture = new BioAuth();
        $fixture->setIdentification('My Title');
        $fixture->setDateCreated('My Title');
        $fixture->setStatus('My Title');
        $fixture->setApplication('My Title');
        $fixture->setPerson('My Title');

        $this->repository->add($fixture, true);

        self::assertSame($originalNumObjectsInRepository + 1, count($this->repository->findAll()));

        $this->client->request('GET', sprintf('%s%s', $this->path, $fixture->getId()));
        $this->client->submitForm('Delete');

        self::assertSame($originalNumObjectsInRepository, count($this->repository->findAll()));
        self::assertResponseRedirects('/bio/auth/');
    }
}
